﻿namespace MediaInfoLib.MediaInfoWrapper
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Reflection;
    using System.Runtime.InteropServices;
    using MediaInfoLib;

    public class MediaInfo : IDisposable
    {
        private List<AudioTrack> _Audio;
        private int _AudioCount;
        private List<ChaptersTrack> _Chapters;
        private int _ChaptersCount;
        private string _FileName;
        private List<GeneralTrack> _General;
        private int _GeneralCount;
        private List<TextTrack> _Text;
        private int _TextCount;
        private List<VideoTrack> _Video;
        private int _VideoCount;
        private bool disposed;
        private MediaInfoLib.MediaInfo MediaInfoLibClass;

// Constructor
        public MediaInfo(string path)
        {
            if (this.CheckFileExistence(path))
            {
                this._FileName = path;
                MediaInfoLibClass = new MediaInfoLib.MediaInfo();
                MediaInfoLibClass.Open(path);
                try
                {
                    this.getStreamCount();
                    this.getAllInfos();
                }
                finally
                {
                    MediaInfoLibClass.Close();
                }
            }
        }

// Capatibility
        public static string Version()
        {
            MediaInfoLib.MediaInfo MediaInfoLibClass = new MediaInfoLib.MediaInfo();
            return MediaInfoLibClass.Option("Info_Version", "");
        }

        public static string KnownCodecs()
        {
            MediaInfoLib.MediaInfo MediaInfoLibClass = new MediaInfoLib.MediaInfo();
            return MediaInfoLibClass.Option("Info_Codecs", "");
        }

        private static string ParameterList()
        {
            MediaInfoLib.MediaInfo MediaInfoLibClass = new MediaInfoLib.MediaInfo();
            return MediaInfoLibClass.Option("Info_Parameters", "");
        }

        protected void CheckDisposed()
        {
            if (this.disposed)
            {
                throw new ObjectDisposedException(this.ToString());
            }
        }

        protected bool CheckFileExistence(string filepath)
        {
            if (!File.Exists(filepath))
            {
                throw new FileNotFoundException("File not found :" + filepath, filepath);
            }
            return true;
        }

        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    this.DisposeManagedResources();
                }
                this.DisposeUnmanagedResources();
            }
            this.disposed = true;
        }

        protected virtual void DisposeManagedResources()
        {
        }

        protected virtual void DisposeUnmanagedResources()
        {
            MediaInfoLibClass.Close();
        }

        ~MediaInfo()
        {
            this.Dispose(false);
        }

        private void getAllInfos()
        {
            this.getVideoInfo();
            this.getAudioInfo();
            this.getChaptersInfo();
            this.getTextInfo();
            this.getGeneralInfo();
        }

        private void getAudioInfo()
        {
            if (this._Audio == null)
            {
                this._Audio = new List<AudioTrack>();
                int num = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Audio);
                if (num > 0)
                {
                    int num2 = num - 1;
                    for (int i = 0; i <= num2; i++)
                    {
                        AudioTrack item = new AudioTrack {
                            Count = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Count"),
                            Status = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Status"),
                            StreamCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamCount"),
                            StreamKind = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamKind"),
                            StreamKindString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamKind/String"),
                            StreamKindID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamKindID"),
                            StreamKindPos = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamKindPos"),
                            Inform = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Inform"),
                            ID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "ID"),
                            IDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "ID/String"),
                            UniqueID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "UniqueID"),
                            UniqueIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "UniqueID/String"),
                            MenuID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "MenuID"),
                            MenuIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "MenuID/String"),
                            Format = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format"),
                            FormatInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format/Info"),
                            FormatUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format/Url"),
                            Format_Commercial = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Commercial"),
                            Format_Commercial_IfAny = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Commercial_IfAny"),
                            Format_Version = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Version"),
                            Format_Profile = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Profile"),
                            Format_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings"),
                            Format_Settings_SBR = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_SBR"),
                            Format_Settings_SBRString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_SBR/String"),
                            Format_Settings_PS = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_PS"),
                            Format_Settings_PSString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_PS/String"),
                            Format_Settings_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Mode"),
                            Format_Settings_ModeExtension = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_ModeExtension"),
                            Format_Settings_Emphasis = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Emphasis"),
                            Format_Settings_Floor = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Floor"),
                            Format_Settings_Firm = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Firm"),
                            Format_Settings_Endianness = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Endianness"),
                            Format_Settings_Sign = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Sign"),
                            Format_Settings_Law = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Law"),
                            Format_Settings_ITU = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_ITU"),
                            Format_Settings_Wrapping = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Format_Settings_Wrapping"),
                            InternetMediaType = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "InternetMediaType"),
                            MuxingMode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "MuxingMode"),
                            MuxingMode_MoreInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "MuxingMode_MoreInfo"),
                            CodecID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "CodecID"),
                            CodecIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "CodecID/String"),
                            CodecIDInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "CodecID/Info"),
                            CodecIDHint = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "CodecID/Hint"),
                            CodecIDUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "CodecID/Url"),
                            CodecID_Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "CodecID_Description"),
                            Codec = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec"),
                            CodecString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec/String"),
                            CodecFamily = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec/Family"),
                            CodecInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec/Info"),
                            CodecUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec/Url"),
                            CodecCC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec/CC"),
                            Codec_Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Description"),
                            Codec_Profile = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Profile"),
                            Codec_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings"),
                            Codec_Settings_Automatic = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings_Automatic"),
                            Codec_Settings_Floor = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings_Floor"),
                            Codec_Settings_Firm = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings_Firm"),
                            Codec_Settings_Endianness = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings_Endianness"),
                            Codec_Settings_Sign = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings_Sign"),
                            Codec_Settings_Law = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings_Law"),
                            Codec_Settings_ITU = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Codec_Settings_ITU"),
                            Duration = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Duration"),
                            DurationString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Duration/String"),
                            DurationString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Duration/String1"),
                            DurationString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Duration/String2"),
                            DurationString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Duration/String3"),
                            BitRate_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Mode"),
                            BitRate_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Mode/String"),
                            BitRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate"),
                            BitRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate/String"),
                            BitRate_Minimum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Minimum"),
                            BitRate_MinimumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Minimum/String"),
                            BitRate_Nominal = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Nominal"),
                            BitRate_NominalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Nominal/String"),
                            BitRate_Maximum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Maximum"),
                            BitRate_MaximumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitRate_Maximum/String"),
                            Channels = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Channel(s)"),
                            ChannelsString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Channel(s)/String"),
                            ChannelPositions = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "ChannelPositions"),
                            ChannelPositionsString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "ChannelPositions/String2"),
                            SamplingRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "SamplingRate"),
                            SamplingRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "SamplingRate/String"),
                            SamplingCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "SamplingCount"),
                            FrameRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "FrameRate"),
                            FrameRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "FrameRate/String"),
                            FrameCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "FrameCount"),
                            Resolution = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Resolution"),
                            ResolutionString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Resolution/String"),
                            BitDepth = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitDepth"),
                            BitDepthString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "BitDepth/String"),
                            Compression_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Compression_Mode"),
                            Compression_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Compression_Mode/String"),
                            Compression_Ratio = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Compression_Ratio"),
                            Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay"),
                            DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay/String"),
                            DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay/String1"),
                            DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay/String2"),
                            DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay/String3"),
                            DelayString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay/String4"),
                            Delay_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Settings"),
                            Delay_Source = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Source"),
                            Delay_SourceString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Source/String"),
                            Delay_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original"),
                            Delay_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original/String"),
                            Delay_OriginalString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original/String1"),
                            Delay_OriginalString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original/String2"),
                            Delay_OriginalString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original/String3"),
                            Delay_OriginalString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original/String4"),
                            Delay_Original_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original_Settings"),
                            Delay_Original_Source = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Delay_Original_Source"),
                            Video_Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video_Delay"),
                            Video_DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video_Delay/String"),
                            Video_DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video_Delay/String1"),
                            Video_DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video_Delay/String2"),
                            Video_DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video_Delay/String3"),
                            Video_DelayString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video_Delay/String4"),
                            Video0_Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video0_Delay"),
                            Video0_DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video0_Delay/String"),
                            Video0_DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video0_Delay/String1"),
                            Video0_DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video0_Delay/String2"),
                            Video0_DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video0_Delay/String3"),
                            Video0_DelayString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Video0_Delay/String4"),
                            ReplayGain_Gain = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "ReplayGain_Gain"),
                            ReplayGain_GainString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "ReplayGain_Gain/String"),
                            ReplayGain_Peak = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "ReplayGain_Peak"),
                            StreamSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize"),
                            StreamSizeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize/String"),
                            StreamSizeString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize/String1"),
                            StreamSizeString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize/String2"),
                            StreamSizeString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize/String3"),
                            StreamSizeString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize/String4"),
                            StreamSizeString5 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize/String5"),
                            StreamSize_Proportion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "StreamSize_Proportion"),
                            Alignment = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Alignment"),
                            AlignmentString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Alignment/String"),
                            Interleave_VideoFrames = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Interleave_VideoFrames"),
                            Interleave_Duration = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Interleave_Duration"),
                            Interleave_DurationString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Interleave_Duration/String"),
                            Interleave_Preload = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Interleave_Preload"),
                            Interleave_PreloadString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Interleave_Preload/String"),
                            Title = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Title"),
                            Encoded_Library = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encoded_Library"),
                            Encoded_LibraryString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encoded_Library/String"),
                            Encoded_LibraryName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encoded_Library/Name"),
                            Encoded_LibraryVersion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encoded_Library/Version"),
                            Encoded_LibraryDate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encoded_Library/Date"),
                            Encoded_Library_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encoded_Library_Settings"),
                            Language = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Language"),
                            LanguageString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Language/String"),
                            LanguageString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Language/String1"),
                            LanguageString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Language/String2"),
                            LanguageString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Language/String3"),
                            LanguageString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Language/String4"),
                            Language_More = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Language_More"),
                            Encoded_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encoded_Date"),
                            Tagged_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Tagged_Date"),
                            Encryption = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Audio, i, "Encryption")
                        };
                        this._Audio.Add(item);
                    }
                }
            }
        }

        private void getChaptersInfo()
        {
            if (this._Chapters == null)
            {
                this._Chapters = new List<ChaptersTrack>();
                int num = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Chapters);
                if (num > 0)
                {
                    int num2 = num - 1;
                    for (int i = 0; i <= num2; i++)
                    {
                        ChaptersTrack item = new ChaptersTrack {
                            Count = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Count"),
                            StreamCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "StreamCount"),
                            StreamKind = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "StreamKind"),
                            StreamKindString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "StreamKind/String"),
                            StreamKindID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "StreamKindID"),
                            StreamKindPos = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "StreamKindPos"),
                            Inform = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Inform"),
                            ID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "ID"),
                            IDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "ID/String"),
                            UniqueID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "UniqueID"),
                            MenuID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "MenuID"),
                            MenuIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "MenuID/String"),
                            Format = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Format"),
                            FormatInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Format/Info"),
                            FormatUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Format/Url"),
                            Codec = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Codec"),
                            CodecString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Codec/String"),
                            CodecInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Codec/Info"),
                            CodecUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Codec/Url"),
                            Total = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Total"),
                            Title = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Title"),
                            Language = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Language"),
                            LanguageString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Chapters, i, "Language/String")
                        };
                        this._Chapters.Add(item);
                    }
                }
            }
        }

        private void getGeneralInfo()
        {
            if (this._General == null)
            {
                this._General = new List<GeneralTrack>();
                int num = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.General);
                if (num > 0)
                {
                    int num2 = num - 1;
                    for (int i = 0; i <= num2; i++)
                    {
                        GeneralTrack item = new GeneralTrack {
                            Count = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Count"),
                            Status = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Status"),
                            StreamCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamCount"),
                            StreamKind = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamKind"),
                            StreamKindString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamKind/String"),
                            StreamKindID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamKindID"),
                            StreamKindPos = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamKindPos"),
                            Inform = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Inform"),
                            ID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ID"),
                            IDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ID/String"),
                            UniqueID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "UniqueID"),
                            UniqueIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "UniqueID/String"),
                            MenuID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "MenuID"),
                            MenuIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "MenuID/String"),
                            GeneralCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "GeneralCount"),
                            VideoCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "VideoCount"),
                            AudioCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "AudioCount"),
                            TextCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "TextCount"),
                            ChaptersCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ChaptersCount"),
                            ImageCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ImageCount"),
                            MenuCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "MenuCount"),
                            Video_Format_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Video_Format_List"),
                            Video_Format_WithHint_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Video_Format_WithHint_List"),
                            Video_Codec_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Video_Codec_List"),
                            Video_Language_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Video_Language_List"),
                            Audio_Format_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Audio_Format_List"),
                            Audio_Format_WithHint_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Audio_Format_WithHint_List"),
                            Audio_Codec_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Audio_Codec_List"),
                            Audio_Language_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Audio_Language_List"),
                            Text_Format_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Text_Format_List"),
                            Text_Format_WithHint_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Text_Format_WithHint_List"),
                            Text_Codec_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Text_Codec_List"),
                            Text_Language_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Text_Language_List"),
                            Chapters_Format_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Chapters_Format_List"),
                            Chapters_Format_WithHint_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Chapters_Format_WithHint_List"),
                            Chapters_Codec_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Chapters_Codec_List"),
                            Chapters_Language_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Chapters_Language_List"),
                            Image_Format_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Image_Format_List"),
                            Image_Format_WithHint_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Image_Format_WithHint_List"),
                            Image_Codec_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Image_Codec_List"),
                            Image_Language_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Image_Language_List"),
                            Menu_Format_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Menu_Format_List"),
                            Menu_Format_WithHint_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Menu_Format_WithHint_List"),
                            Menu_Codec_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Menu_Codec_List"),
                            Menu_Language_List = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Menu_Language_List"),
                            CompleteName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CompleteName"),
                            FolderName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FolderName"),
                            FileName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileName"),
                            FileExtension = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileExtension"),
                            Format = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format"),
                            FormatString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format/String"),
                            FormatInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format/Info"),
                            FormatUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format/Url"),
                            FormatExtensions = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format/Extensions"),
                            Format_Commercial = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format_Commercial"),
                            Format_Commercial_IfAny = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format_Commercial_IfAny"),
                            Format_Version = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format_Version"),
                            Format_Profile = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format_Profile"),
                            Format_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Format_Settings"),
                            InternetMediaType = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "InternetMediaType"),
                            CodecID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CodecID"),
                            CodecIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CodecID/String"),
                            CodecIDInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CodecID/Info"),
                            CodecIDHint = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CodecID/Hint"),
                            CodecIDUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CodecID/Url"),
                            CodecID_Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CodecID_Description"),
                            Interleaved = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Interleaved"),
                            Codec = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Codec"),
                            CodecString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Codec/String"),
                            CodecInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Codec/Info"),
                            CodecUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Codec/Url"),
                            CodecExtensions = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Codec/Extensions"),
                            Codec_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Codec_Settings"),
                            Codec_Settings_Automatic = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Codec_Settings_Automatic"),
                            FileSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileSize"),
                            FileSizeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileSize/String"),
                            FileSizeString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileSize/String1"),
                            FileSizeString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileSize/String2"),
                            FileSizeString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileSize/String3"),
                            FileSizeString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FileSize/String4"),
                            Duration = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Duration"),
                            DurationString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Duration/String"),
                            DurationString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Duration/String1"),
                            DurationString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Duration/String2"),
                            DurationString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Duration/String3"),
                            Duration_Start = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Duration_Start"),
                            Duration_End = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Duration_End"),
                            OverallBitRate_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Mode"),
                            OverallBitRate_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Mode/String"),
                            OverallBitRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate"),
                            OverallBitRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate/String"),
                            OverallBitRate_Minimum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Minimum"),
                            OverallBitRate_MinimumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Minimum/String"),
                            OverallBitRate_Nominal = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Nominal"),
                            OverallBitRate_NominalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Nominal/String"),
                            OverallBitRate_Maximum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Maximum"),
                            OverallBitRate_MaximumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OverallBitRate_Maximum/String"),
                            Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Delay"),
                            DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Delay/String"),
                            DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Delay/String1"),
                            DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Delay/String2"),
                            DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Delay/String3"),
                            StreamSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize"),
                            StreamSizeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize/String"),
                            StreamSizeString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize/String1"),
                            StreamSizeString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize/String2"),
                            StreamSizeString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize/String3"),
                            StreamSizeString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize/String4"),
                            StreamSizeString5 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize/String5"),
                            StreamSize_Proportion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "StreamSize_Proportion"),
                            HeaderSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "HeaderSize"),
                            DataSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "DataSize"),
                            FooterSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "FooterSize"),
                            IsStreamable = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "IsStreamable"),
                            Album_ReplayGain_Gain = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album_ReplayGain_Gain"),
                            Album_ReplayGain_GainString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album_ReplayGain_Gain/String"),
                            Album_ReplayGain_Peak = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album_ReplayGain_Peak"),
                            Encryption = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encryption"),
                            Title = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Title"),
                            TitleMore = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Title/More"),
                            TitleUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Title/Url"),
                            Domain = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Domain"),
                            Collection = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Collection"),
                            Season = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Season"),
                            Season_Position = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Season_Position"),
                            Season_Position_Total = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Season_Position_Total"),
                            Movie = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Movie"),
                            MovieMore = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Movie/More"),
                            MovieCountry = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Movie/Country"),
                            MovieUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Movie/Url"),
                            Album = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album"),
                            AlbumMore = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album/More"),
                            AlbumSort = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album/Sort"),
                            AlbumPerformer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album/Performer"),
                            AlbumPerformerSort = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album/Performer/Sort"),
                            AlbumPerformerUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Album/Performer/Url"),
                            Comic = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Comic"),
                            ComicMore = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Comic/More"),
                            ComicPosition_Total = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Comic/Position_Total"),
                            Part = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Part"),
                            PartPosition = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Part/Position"),
                            PartPosition_Total = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Part/Position_Total"),
                            Track = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Track"),
                            TrackMore = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Track/More"),
                            TrackUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Track/Url"),
                            TrackSort = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Track/Sort"),
                            TrackPosition = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Track/Position"),
                            TrackPosition_Total = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Track/Position_Total"),
                            Grouping = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Grouping"),
                            Chapter = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Chapter"),
                            SubTrack = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "SubTrack"),
                            OriginalAlbum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Original/Album"),
                            OriginalMovie = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Original/Movie"),
                            OriginalPart = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Original/Part"),
                            OriginalTrack = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Original/Track"),
                            Compilation = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Compilation"),
                            CompilationString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Compilation/String"),
                            Performer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Performer"),
                            PerformerSort = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Performer/Sort"),
                            PerformerUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Performer/Url"),
                            OriginalPerformer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Original/Performer"),
                            Accompaniment = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Accompaniment"),
                            Composer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Composer"),
                            ComposerNationality = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Composer/Nationality"),
                            Arranger = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Arranger"),
                            Lyricist = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Lyricist"),
                            OriginalLyricist = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Original/Lyricist"),
                            Conductor = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Conductor"),
                            Director = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Director"),
                            AssistantDirector = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "AssistantDirector"),
                            DirectorOfPhotography = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "DirectorOfPhotography"),
                            SoundEngineer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "SoundEngineer"),
                            ArtDirector = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ArtDirector"),
                            ProductionDesigner = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ProductionDesigner"),
                            Choregrapher = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Choregrapher"),
                            CostumeDesigner = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CostumeDesigner"),
                            Actor = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Actor"),
                            Actor_Character = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Actor_Character"),
                            WrittenBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "WrittenBy"),
                            ScreenplayBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ScreenplayBy"),
                            EditedBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "EditedBy"),
                            CommissionedBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CommissionedBy"),
                            Producer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Producer"),
                            CoProducer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CoProducer"),
                            ExecutiveProducer = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ExecutiveProducer"),
                            MusicBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "MusicBy"),
                            DistributedBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "DistributedBy"),
                            OriginalSourceFormDistributedBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalSourceForm/DistributedBy"),
                            MasteredBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "MasteredBy"),
                            EncodedBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "EncodedBy"),
                            RemixedBy = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "RemixedBy"),
                            ProductionStudio = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ProductionStudio"),
                            ThanksTo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ThanksTo"),
                            Publisher = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Publisher"),
                            PublisherURL = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Publisher/URL"),
                            Label = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Label"),
                            Genre = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Genre"),
                            Mood = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Mood"),
                            ContentType = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ContentType"),
                            Subject = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Subject"),
                            Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Description"),
                            Keywords = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Keywords"),
                            Summary = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Summary"),
                            Synopsis = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Synopsis"),
                            Period = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Period"),
                            LawRating = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "LawRating"),
                            LawRating_Reason = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "LawRating_Reason"),
                            ICRA = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ICRA"),
                            Released_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Released_Date"),
                            OriginalReleased_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Original/Released_Date"),
                            Recorded_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Recorded_Date"),
                            Encoded_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Date"),
                            Tagged_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Tagged_Date"),
                            Written_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Written_Date"),
                            Mastered_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Mastered_Date"),
                            File_Created_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "File_Created_Date"),
                            File_Created_Date_Local = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "File_Created_Date_Local"),
                            File_Modified_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "File_Modified_Date"),
                            File_Modified_Date_Local = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "File_Modified_Date_Local"),
                            Recorded_Location = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Recorded_Location"),
                            Written_Location = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Written_Location"),
                            Archival_Location = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Archival_Location"),
                            Encoded_Application = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Application"),
                            Encoded_ApplicationUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Application/Url"),
                            Encoded_Library = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Library"),
                            Encoded_LibraryString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Library/String"),
                            Encoded_LibraryName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Library/Name"),
                            Encoded_LibraryVersion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Library/Version"),
                            Encoded_LibraryDate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Library/Date"),
                            Encoded_Library_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Encoded_Library_Settings"),
                            Cropped = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Cropped"),
                            Dimensions = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Dimensions"),
                            DotsPerInch = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "DotsPerInch"),
                            Lightness = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Lightness"),
                            OriginalSourceMedium = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalSourceMedium"),
                            OriginalSourceForm = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalSourceForm"),
                            OriginalSourceFormNumColors = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalSourceForm/NumColors"),
                            OriginalSourceFormName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalSourceForm/Name"),
                            OriginalSourceFormCropped = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalSourceForm/Cropped"),
                            OriginalSourceFormSharpness = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalSourceForm/Sharpness"),
                            Tagged_Application = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Tagged_Application"),
                            BPM = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "BPM"),
                            ISRC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ISRC"),
                            ISBN = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ISBN"),
                            BarCode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "BarCode"),
                            LCCN = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "LCCN"),
                            CatalogNumber = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "CatalogNumber"),
                            LabelCode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "LabelCode"),
                            Owner = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Owner"),
                            Copyright = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Copyright"),
                            CopyrightUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Copyright/Url"),
                            Producer_Copyright = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Producer_Copyright"),
                            TermsOfUse = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "TermsOfUse"),
                            ServiceName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ServiceName"),
                            ServiceChannel = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ServiceChannel"),
                            ServiceUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Service/Url"),
                            ServiceProvider = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ServiceProvider"),
                            ServiceProviderrUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ServiceProviderr/Url"),
                            ServiceType = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "ServiceType"),
                            NetworkName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "NetworkName"),
                            OriginalNetworkName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "OriginalNetworkName"),
                            Country = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Country"),
                            TimeZone = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "TimeZone"),
                            Cover = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Cover"),
                            Cover_Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Cover_Description"),
                            Cover_Type = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Cover_Type"),
                            Cover_Mime = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Cover_Mime"),
                            Cover_Data = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Cover_Data"),
                            Lyrics = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Lyrics"),
                            Comment = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Comment"),
                            Rating = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Rating"),
                            Added_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Added_Date"),
                            Played_First_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Played_First_Date"),
                            Played_Last_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Played_Last_Date"),
                            Played_Count = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "Played_Count"),
                            EPG_Positions_Begin = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "EPG_Positions_Begin"),
                            EPG_Positions_End = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.General, i, "EPG_Positions_End")
                        };
                        this._General.Add(item);
                    }
                }
            }
        }

        private void getStreamCount()
        {
            this._AudioCount = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Audio);
            this._VideoCount = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Video);
            this._GeneralCount = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.General);
            this._TextCount = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Text);
            this._ChaptersCount = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Chapters);
        }

        private void getTextInfo()
        {
            if (this._Text == null)
            {
                this._Text = new List<TextTrack>();
                int num = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Text);
                if (num > 0)
                {
                    int num2 = num - 1;
                    for (int i = 0; i <= num2; i++)
                    {
                        TextTrack item = new TextTrack {
                            Count = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Count"),
                            Status = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Status"),
                            StreamCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamCount"),
                            StreamKind = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamKind"),
                            StreamKindString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamKind/String"),
                            StreamKindID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamKindID"),
                            StreamKindPos = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamKindPos"),
                            Inform = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Inform"),
                            ID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "ID"),
                            IDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "ID/String"),
                            UniqueID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "UniqueID"),
                            UniqueIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "UniqueID/String"),
                            MenuID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "MenuID"),
                            MenuIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "MenuID/String"),
                            Format = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format"),
                            FormatInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format/Info"),
                            FormatUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format/Url"),
                            Format_Commercial = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format_Commercial"),
                            Format_Commercial_IfAny = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format_Commercial_IfAny"),
                            Format_Version = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format_Version"),
                            Format_Profile = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format_Profile"),
                            Format_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format_Settings"),
                            Format_Settings_Wrapping = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Format_Settings_Wrapping"),
                            InternetMediaType = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "InternetMediaType"),
                            MuxingMode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "MuxingMode"),
                            MuxingMode_MoreInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "MuxingMode_MoreInfo"),
                            CodecID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "CodecID"),
                            CodecIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "CodecID/String"),
                            CodecIDInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "CodecID/Info"),
                            CodecIDHint = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "CodecID/Hint"),
                            CodecIDUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "CodecID/Url"),
                            CodecID_Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "CodecID_Description"),
                            Codec = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Codec"),
                            CodecString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Codec/String"),
                            CodecInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Codec/Info"),
                            CodecUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Codec/Url"),
                            CodecCC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Codec/CC"),
                            Duration = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Duration"),
                            DurationString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Duration/String"),
                            DurationString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Duration/String1"),
                            DurationString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Duration/String2"),
                            DurationString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Duration/String3"),
                            DurationString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Duration/String4"),
                            BitRate_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Mode"),
                            BitRate_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Mode/String"),
                            BitRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate"),
                            BitRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate/String"),
                            BitRate_Minimum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Minimum"),
                            BitRate_MinimumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Minimum/String"),
                            BitRate_Nominal = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Nominal"),
                            BitRate_NominalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Nominal/String"),
                            BitRate_Maximum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Maximum"),
                            BitRate_MaximumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitRate_Maximum/String"),
                            Width = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Width"),
                            WidthString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Width/String"),
                            Height = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Height"),
                            HeightString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Height/String"),
                            FrameRate_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Mode"),
                            FrameRate_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Mode/String"),
                            FrameRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate"),
                            FrameRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate/String"),
                            FrameRate_Minimum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Minimum"),
                            FrameRate_MinimumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Minimum/String"),
                            FrameRate_Nominal = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Nominal"),
                            FrameRate_NominalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Nominal/String"),
                            FrameRate_Maximum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Maximum"),
                            FrameRate_MaximumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Maximum/String"),
                            FrameRate_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Original"),
                            FrameRate_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameRate_Original/String"),
                            FrameCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "FrameCount"),
                            ColorSpace = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "ColorSpace"),
                            ChromaSubsampling = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "ChromaSubsampling"),
                            Resolution = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Resolution"),
                            ResolutionString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Resolution/String"),
                            BitDepth = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitDepth"),
                            BitDepthString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "BitDepth/String"),
                            Compression_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Compression_Mode"),
                            Compression_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Compression_Mode/String"),
                            Compression_Ratio = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Compression_Ratio"),
                            Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay"),
                            DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay/String"),
                            DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay/String1"),
                            DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay/String2"),
                            DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay/String3"),
                            DelayString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay/String4"),
                            Delay_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Settings"),
                            Delay_Source = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Source"),
                            Delay_SourceString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Source/String"),
                            Delay_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original"),
                            Delay_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original/String"),
                            Delay_OriginalString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original/String1"),
                            Delay_OriginalString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original/String2"),
                            Delay_OriginalString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original/String3"),
                            Delay_OriginalString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original/String4"),
                            Delay_Original_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original_Settings"),
                            Delay_Original_Source = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Delay_Original_Source"),
                            Video_Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video_Delay"),
                            Video_DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video_Delay/String"),
                            Video_DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video_Delay/String1"),
                            Video_DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video_Delay/String2"),
                            Video_DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video_Delay/String3"),
                            Video_DelayString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video_Delay/String4"),
                            Video0_Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video0_Delay"),
                            Video0_DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video0_Delay/String"),
                            Video0_DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video0_Delay/String1"),
                            Video0_DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video0_Delay/String2"),
                            Video0_DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video0_Delay/String3"),
                            Video0_DelayString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Video0_Delay/String4"),
                            StreamSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize"),
                            StreamSizeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize/String"),
                            StreamSizeString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize/String1"),
                            StreamSizeString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize/String2"),
                            StreamSizeString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize/String3"),
                            StreamSizeString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize/String4"),
                            StreamSizeString5 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize/String5"),
                            StreamSize_Proportion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "StreamSize_Proportion"),
                            Title = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Title"),
                            Encoded_Library = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encoded_Library"),
                            Encoded_LibraryString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encoded_Library/String"),
                            Encoded_LibraryName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encoded_Library/Name"),
                            Encoded_LibraryVersion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encoded_Library/Version"),
                            Encoded_LibraryDate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encoded_Library/Date"),
                            Encoded_Library_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encoded_Library_Settings"),
                            Language = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Language"),
                            LanguageString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Language/String"),
                            LanguageString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Language/String1"),
                            LanguageString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Language/String2"),
                            LanguageString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Language/String3"),
                            LanguageString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Language/String4"),
                            Language_More = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Language_More"),
                            Summary = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Summary"),
                            Encoded_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encoded_Date"),
                            Tagged_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Tagged_Date"),
                            Encryption = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Text, i, "Encryption")
                        };
                        this._Text.Add(item);
                    }
                }
            }
        }

        private void getVideoInfo()
        {
            if (this._Video == null)
            {
                this._Video = new List<VideoTrack>();
                int num = MediaInfoLibClass.Count_Get(MediaInfoLib.StreamKind.Video);
                if (num > 0)
                {
                    int num2 = num - 1;
                    for (int i = 0; i <= num2; i++)
                    {
                        VideoTrack item = new VideoTrack {
                            Count = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Count"),
                            Status = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Status"),
                            StreamCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamCount"),
                            StreamKind = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamKind"),
                            StreamKindString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamKind/String"),
                            StreamKindID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamKindID"),
                            StreamKindPos = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamKindPos"),
                            Inform = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Inform"),
                            ID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ID"),
                            IDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ID/String"),
                            UniqueID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "UniqueID"),
                            UniqueIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "UniqueID/String"),
                            MenuID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "MenuID"),
                            MenuIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "MenuID/String"),
                            Format = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format"),
                            FormatInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format/Info"),
                            FormatUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format/Url"),
                            Format_Commercial = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Commercial"),
                            Format_Commercial_IfAny = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Commercial_IfAny"),
                            Format_Version = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Version"),
                            Format_Profile = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Profile"),
                            MultiView_BaseProfile = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "MultiView_BaseProfile"),
                            MultiView_Count = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "MultiView_Count"),
                            Format_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings"),
                            Format_Settings_BVOP = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_BVOP"),
                            Format_Settings_BVOPString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_BVOP/String"),
                            Format_Settings_QPel = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_QPel"),
                            Format_Settings_QPelString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_QPel/String"),
                            Format_Settings_GMC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_GMC"),
                            Format_Settings_GMCString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_GMC/String"),
                            Format_Settings_Matrix = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_Matrix"),
                            Format_Settings_MatrixString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_Matrix/String"),
                            Format_Settings_Matrix_Data = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_Matrix_Data"),
                            Format_Settings_CABAC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_CABAC"),
                            Format_Settings_CABACString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_CABAC/String"),
                            Format_Settings_RefFrames = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_RefFrames"),
                            Format_Settings_RefFramesString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_RefFrames/String"),
                            Format_Settings_Pulldown = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_Pulldown"),
                            Format_Settings_FrameMode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_FrameMode"),
                            Format_Settings_GOP = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_GOP"),
                            Format_Settings_FrameStructures = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_FrameStructures"),
                            Format_Settings_Wrapping = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Format_Settings_Wrapping"),
                            InternetMediaType = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "InternetMediaType"),
                            MuxingMode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "MuxingMode"),
                            CodecID = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "CodecID"),
                            CodecIDString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "CodecID/String"),
                            CodecIDInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "CodecID/Info"),
                            CodecIDHint = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "CodecID/Hint"),
                            CodecIDUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "CodecID/Url"),
                            CodecID_Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "CodecID_Description"),
                            Codec = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec"),
                            CodecString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec/String"),
                            CodecFamily = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec/Family"),
                            CodecInfo = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec/Info"),
                            CodecUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec/Url"),
                            CodecCC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec/CC"),
                            Codec_Profile = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Profile"),
                            Codec_Description = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Description"),
                            Codec_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings"),
                            Codec_Settings_PacketBitStream = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_PacketBitStream"),
                            Codec_Settings_BVOP = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_BVOP"),
                            Codec_Settings_QPel = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_QPel"),
                            Codec_Settings_GMC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_GMC"),
                            Codec_Settings_GMCString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_GMC/String"),
                            Codec_Settings_Matrix = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_Matrix"),
                            Codec_Settings_Matrix_Data = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_Matrix_Data"),
                            Codec_Settings_CABAC = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_CABAC"),
                            Codec_Settings_RefFrames = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Codec_Settings_RefFrames"),
                            Duration = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration"),
                            DurationString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration/String"),
                            DurationString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration/String1"),
                            DurationString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration/String2"),
                            DurationString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration/String3"),
                            DurationString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration/String4"),
                            Duration_LastFrame = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration_LastFrame"),
                            Duration_LastFrameString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration_LastFrame/String"),
                            Duration_LastFrameString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration_LastFrame/String1"),
                            Duration_LastFrameString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration_LastFrame/String2"),
                            Duration_LastFrameString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Duration_LastFrame/String3"),
                            BitRate_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Mode"),
                            BitRate_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Mode/String"),
                            BitRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate"),
                            BitRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate/String"),
                            BitRate_Minimum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Minimum"),
                            BitRate_MinimumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Minimum/String"),
                            BitRate_Nominal = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Nominal"),
                            BitRate_NominalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Nominal/String"),
                            BitRate_Maximum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Maximum"),
                            BitRate_MaximumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitRate_Maximum/String"),
                            Width = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Width"),
                            WidthString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Width/String"),
                            Width_Offset = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Width_Offset"),
                            Width_OffsetString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Width_Offset/String"),
                            Width_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Width_Original"),
                            Width_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Width_Original/String"),
                            Height = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Height"),
                            HeightString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Height/String"),
                            Height_Offset = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Height_Offset"),
                            Height_OffsetString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Height_Offset/String"),
                            Height_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Height_Original"),
                            Height_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Height_Original/String"),
                            PixelAspectRatio = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "PixelAspectRatio"),
                            PixelAspectRatioString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "PixelAspectRatio/String"),
                            PixelAspectRatio_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "PixelAspectRatio_Original"),
                            PixelAspectRatio_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "PixelAspectRatio_Original/String"),
                            DisplayAspectRatio = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "DisplayAspectRatio"),
                            DisplayAspectRatioString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "DisplayAspectRatio/String"),
                            DisplayAspectRatio_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "DisplayAspectRatio_Original"),
                            DisplayAspectRatio_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "DisplayAspectRatio_Original/String"),
                            ActiveFormatDescription = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ActiveFormatDescription"),
                            ActiveFormatDescriptionString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ActiveFormatDescription/String"),
                            Rotation = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Rotation"),
                            RotationString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Rotation/String"),
                            FrameRate_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Mode"),
                            FrameRate_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Mode/String"),
                            FrameRate_Mode_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Mode_Original"),
                            FrameRate_Mode_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Mode_Original/String"),
                            FrameRate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate"),
                            FrameRateString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate/String"),
                            FrameRate_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Original"),
                            FrameRate_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Original/String"),
                            FrameRate_Minimum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Minimum"),
                            FrameRate_MinimumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Minimum/String"),
                            FrameRate_Nominal = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Nominal"),
                            FrameRate_NominalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Nominal/String"),
                            FrameRate_Maximum = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Maximum"),
                            FrameRate_MaximumString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameRate_Maximum/String"),
                            FrameCount = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "FrameCount"),
                            Standard = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Standard"),
                            Resolution = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Resolution"),
                            ResolutionString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Resolution/String"),
                            Colorimetry = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Colorimetry"),
                            ColorSpace = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ColorSpace"),
                            ChromaSubsampling = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ChromaSubsampling"),
                            BitDepth = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitDepth"),
                            BitDepthString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BitDepth/String"),
                            ScanType = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ScanType"),
                            ScanTypeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ScanType/String"),
                            ScanOrder = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ScanOrder"),
                            ScanOrderString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "ScanOrder/String"),
                            Interlacement = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Interlacement"),
                            InterlacementString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Interlacement/String"),
                            Compression_Mode = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Compression_Mode"),
                            Compression_ModeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Compression_Mode/String"),
                            Compression_Ratio = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Compression_Ratio"),
                            BitsPixelFrame = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Bits-(Pixel*Frame)"),
                            Delay = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay"),
                            DelayString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay/String"),
                            DelayString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay/String1"),
                            DelayString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay/String2"),
                            DelayString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay/String3"),
                            DelayString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay/String4"),
                            Delay_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Settings"),
                            Delay_Source = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Source"),
                            Delay_SourceString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Source/String"),
                            Delay_Original = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original"),
                            Delay_OriginalString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original/String"),
                            Delay_OriginalString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original/String1"),
                            Delay_OriginalString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original/String2"),
                            Delay_OriginalString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original/String3"),
                            Delay_OriginalString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original/String4"),
                            Delay_Original_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original_Settings"),
                            Delay_Original_Source = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Delay_Original_Source"),
                            StreamSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize"),
                            StreamSizeString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize/String"),
                            StreamSizeString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize/String1"),
                            StreamSizeString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize/String2"),
                            StreamSizeString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize/String3"),
                            StreamSizeString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize/String4"),
                            StreamSizeString5 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize/String5"),
                            StreamSize_Proportion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "StreamSize_Proportion"),
                            Alignment = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Alignment"),
                            AlignmentString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Alignment/String"),
                            Title = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Title"),
                            Encoded_Application = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Application"),
                            Encoded_ApplicationUrl = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Application/Url"),
                            Encoded_Library = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Library"),
                            Encoded_LibraryString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Library/String"),
                            Encoded_LibraryName = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Library/Name"),
                            Encoded_LibraryVersion = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Library/Version"),
                            Encoded_LibraryDate = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Library/Date"),
                            Encoded_Library_Settings = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Library_Settings"),
                            Language = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Language"),
                            LanguageString = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Language/String"),
                            LanguageString1 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Language/String1"),
                            LanguageString2 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Language/String2"),
                            LanguageString3 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Language/String3"),
                            LanguageString4 = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Language/String4"),
                            Language_More = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Language_More"),
                            Encoded_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encoded_Date"),
                            Tagged_Date = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Tagged_Date"),
                            Encryption = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "Encryption"),
                            BufferSize = MediaInfoLibClass.Get(MediaInfoLib.StreamKind.Video, i, "BufferSize")
                        };
                        this._Video.Add(item);
                    }
                }
            }
        }

        private string ListEveryAvailablePropery<T1>(List<T1> L)
        {
            string str = "";
            foreach (T1 local in L)
            {
                foreach (PropertyInfo info in local.GetType().GetProperties())
                {
                    str = str + ((info.GetValue(local, null).ToString() == "") ? (info.Name + " : Not available" + Environment.NewLine) : string.Concat(new object[] { info.Name, " : ", info.GetValue(local, null), Environment.NewLine }));
                }
            }
            return str;
        }

        public List<AudioTrack> Audio
        {
            get
            {
                if (this._Audio == null)
                {
                    this.getAudioInfo();
                }
                return this._Audio;
            }
        }

        public int AudioCount
        {
            get
            {
                return this._AudioCount;
            }
        }

        public List<ChaptersTrack> Chapters
        {
            get
            {
                if (this._Chapters == null)
                {
                    this.getChaptersInfo();
                }
                return this._Chapters;
            }
        }

        public int ChaptersCount
        {
            get
            {
                return this._ChaptersCount;
            }
        }

        public List<GeneralTrack> General
        {
            get
            {
                if (this._General == null)
                {
                    this.getGeneralInfo();
                }
                return this._General;
            }
        }

        public int GeneralCount
        {
            get
            {
                return this._GeneralCount;
            }
        }

        protected bool IsDisposed
        {
            get
            {
                return this.disposed;
            }
        }

        public List<TextTrack> Text
        {
            get
            {
                if (this._Text == null)
                {
                    this.getTextInfo();
                }
                return this._Text;
            }
        }

        public int TextCount
        {
            get
            {
                return this._TextCount;
            }
        }

        public List<VideoTrack> Video
        {
            get
            {
                if (this._Video == null)
                {
                    this.getVideoInfo();
                }
                return this._Video;
            }
        }

        public int VideoCount
        {
            get
            {
                return this._VideoCount;
            }
        }
    }
}

